/***************************************************************************
 *
 * Copyright (C) 2001 International Business Machines
 * All rights reserved.
 *
 * This file is part of the GPFS mmfslinux kernel module.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions 
 * are met:
 *
 *  1. Redistributions of source code must retain the above copyright notice, 
 *     this list of conditions and the following disclaimer. 
 *  2. Redistributions in binary form must reproduce the above copyright 
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution. 
 *  3. The name of the author may not be used to endorse or promote products 
 *     derived from this software without specific prior written
 *     permission. 
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *************************************************************************** */
/* Definitions for program to dump kernel memory */

/*
 * $Id: kdump.h,v 1.1 2001/03/16 21:07:35 wyllie Exp $
 *
 * $Log: kdump.h,v $
 * Revision 1.1  2001/03/16 21:07:35  wyllie
 * Program to dump kernel memory by address or symbol on a running system.
 * Can also get formatted dumps of some kernel data structures.
 *
 */

/* Debugging printfs.  The entire body of the printf call is the macro
   parameter. */
#if 0
#define DBG(_p) _p
#else
#define DBG(_p)
#endif

/* Symbol storage area.  Each symbol has an address, some flags, and
   a name.  Symbols are linked into a hash table by name.  Although the
   symbol array itself is not sorted, the auxiliary array SymsByAddrPP is
   sorted by address to allow fast binary search by address. */
struct Symbol
{
  unsigned long addr;
  int flags;
  char* nameP;
  struct Symbol* hashNextP;
};
#define FL_TEXT     0x01
#define FL_BSS      0x02
#define FL_DATA     0x04
#define FL_RODATA   0x08
#define FL_SECTION  0x10
#define FL_KSTRTAB  0x20

/* Look up symbol by name.  Returns a pointer to the symbol table entry
   if a matching name is found, otherwise NULL. */
extern struct Symbol* LookupSymbolByName(const char* nameP);

/* Add a symbol to the table.  The symbol name must not already be present.
   Returns the address of the new symbol table entry. */
extern struct Symbol* AddUniqueSymbol(unsigned long addr, int flags, char* nameP);

/* Add a symbol to the table.  If the symbol name is already present,
   append the address of the symbol to the symbol name to make it
   unique.  Returns the address of the new symbol table entry. */
extern struct Symbol* AddSymbol(unsigned long addr, int flags, char* nameP);

/* Look up symbol by address.  Returns a pointer to the symbol table entry
   with the largest address that is less than or equal to the given
   address.  There will always be a symbol in the table with address 0,
   so this can always return a pointer to some Symbol object. */
extern struct Symbol* LookupSymbolByAddr(unsigned long addr);

/* Look up a symbol by address.  If an exact match for the address is
   found, return a pointer to the symbol name, otherwise return a pointer
   to an empty string. */
extern const char* ExactAddrToSymbol(unsigned long addr);


/* Bounds of the initial portion of kernel virtual memory.  These are
   initialized to liberal values, then tightened by reading kernel
   variables. */
extern unsigned long LowKernelAddr;
extern unsigned long HighKernelAddr;

/* List of valid virtual memory areas outside of [LowKernelAddr..HighKernelAddr] */
struct vmStruct
{
  unsigned long startAddr;
  int areaLen;
  struct vmStruct* nextAreaP;
};
extern struct vmStruct* vmListHeadP;

/* Read kernel memory after checking the address for validity.  If the address
   is invalid, return -1, otherwise return 0. */
extern int ReadKernel(unsigned long addr, void* bufP, int len);

/* Read the current value of a kernel symbol.  Returns 0 on success, -1
   on failure. */
extern int GetSymbolValue(const char* nameP, void* bufP, int len);

/* Wrappers around malloc and free so they can be called from modules that
   include kernel files */
extern void* kMalloc(int len);
extern void kFree(void* p);

/* Conditional free.  Free storage if p is not NULL. */
extern void CondFree(void* p);

/* Dump a block of memory.  Duplicate lines are supressed. */
#define DUMPMEM_ROUND 0x10
#define DUMPMEM_I1 0x01
#define DUMPMEM_I2 0x02
#define DUMPMEM_I4 0x04
#define DUMPMEM_I8 0x08
extern void DumpMemory(char* p, int nBytes, unsigned long origin, int dumpFlags);
